//
//  ViewController.swift
//  BLE_Sample_Code
//
//  Created by on 2021/12/10.
//

import UIKit
import IOS_SWIFT_BLE_SDK
import CoreBluetooth


class ViewController: UIViewController, UITableViewDataSource,UITableViewDelegate {
    @IBOutlet weak var mScrollView: UIScrollView!
    @IBOutlet weak var mStackView: UIStackView!
    
    let gsble = GTSPL_BLE()
    var BTDictionary = [String: CBPeripheral]()
    var mBleName:String?
    
    @IBOutlet weak var mTableView: UITableView!
    @IBOutlet weak var mTextView: UITextField!

    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.mScrollView.addSubview(mStackView)
        self.mStackView.translatesAutoresizingMaskIntoConstraints = false
        self.mStackView.leadingAnchor.constraint(equalTo: mScrollView.leadingAnchor).isActive=true
        self.mStackView.trailingAnchor.constraint(equalTo: mScrollView.trailingAnchor).isActive=true
        self.mStackView.topAnchor.constraint(equalTo: mScrollView.topAnchor).isActive=true
        self.mStackView.bottomAnchor.constraint(equalTo: mScrollView.bottomAnchor).isActive=true
        self.mStackView.widthAnchor.constraint(equalTo: self.view.widthAnchor).isActive=true
        
    }
    
    //設定tableview 區段數
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    //設定tableview cell數
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return BTDictionary.count
    }
    
    //設定tableview cell內容
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = mTableView.dequeueReusableCell(withIdentifier: "Cell", for: indexPath)
        cell.textLabel?.text = Array(BTDictionary.keys)[indexPath.row]
        return cell
        }
    
    //取得所選取的ble裝置name
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
       print(Array(BTDictionary.keys)[indexPath.row])
        mBleName = Array(BTDictionary.keys)[indexPath.row]
    }
    
    //ble裝置掃描
    @IBAction func onScanClick(_ sender: Any) {
        BTDictionary=[:]
        gsble.searchBLEDevice(){(btDictionary: [String: CBPeripheral]) in
            self.BTDictionary = btDictionary
            for item in self.BTDictionary{
                print("btname \(item.key)")
            }
            //scan後設定table view
            self.mTableView.reloadData()
        }
    }
    
    //ble device connect
    @IBAction func onConnectClick(_ sender: UIButton) {
        guard !BTDictionary.isEmpty else{
            showDialog(title: "Error", msg: "Scan and Select the BLE device first.")
            return
        }
        let btnTitle = sender.titleLabel!.text!
        let btdevice = BTDictionary[mBleName!]
        if btnTitle == "connect"{//連線
            sender.setTitle("disconnect", for: [])
            gsble.openportBLE(connectDevice: btdevice!){(msg) in
                self.mTextView.text = msg
            }
        }else{//斷線
            sender.setTitle("connect", for: [])
            gsble.closeportBLE(connectDevice: btdevice!){(msg) in
                self.mTextView.text = msg
            }
        }
    }
    
    //印表機設定
    @IBAction func onSetupClick(_ sender: Any) {
        gsble.setup(width: 105, height: 80, speed: 4, density: 6, sensor: 0, sensordistance: 5, sensoroffset:5)
    }
    
    //barcode列印
    @IBAction func onBarcodePrintClick(_ sender: Any) {
        gsble.clearBuffer()
        gsble.printBarcode(x: 30, y: 30, type: "128", height: 100, human_readable: 1, rotation: 0, narrow:2, wide: 2, content: "barcode987654321")
        gsble.printLabel(set: 1, copy: 1)
    }
    
    //列印字體
    @IBAction func onPrintFontClick(_ sender: Any) {
        let cn = "默认简体中文测试：海天米醋白米醋1瓶450ml"
        gsble.clearBuffer()
        gsble.printFont(x: 200, y: 200, fontname: "TSS24.BF2", rotation: 0, xScale: 1, yScale: 1, content: cn)
        //gsble.printFont( x: 100, y: 180, fontname: "3", rotation: 0, xScale: 3, yScale: 3, content: "ttf font print test")
        gsble.printLabel(set: 1, copy: 1)
    }
    
    //列印區段文字
    @IBAction func onPrintFontBlockClick(_ sender: Any) {
        let paragraph="We stand behind our products with one of the most comprehensive support programs in the Auto-ID industry."
        gsble.clearBuffer()
        gsble.printFontBlock(x:15,y:15,width:200,height:90,fontname:"1",rotation:0,xScale: 2,yScale:2,space:20,align:0,content:paragraph)
        gsble.printLabel(set: 1, copy: 1)
    }
    
    //bmp列印
    @IBAction func onBMPPrintClick(_ sender: Any) {
        gsble.clearBuffer()
        let url = Bundle.main.url(forResource: "CIRCLE", withExtension:"bmp")!
        gsble.downloadBMP(filepath: url, filename: "CIRCLE.bmp")
        gsble.sendcommand("PUTBMP 30,30,\"CIRCLE.bmp\"\r\n")
        //gsble.downloadPCX(filepath: url, filename: "UL.pcx")
        //gsble.sendcommand("PUTPCX 100,100,\"UL.pcx\"\r\n")
        gsble.printLabel(set: 1, copy: 1)
    }
    
    //查詢印表機狀態
    @IBAction func onPrinterStatusClick(_ sender: Any) {
        var statusStr = ""
        gsble.printerStatus(){(status) in
            switch status{
            case "00":
                statusStr = "Normal"
            case "01":
                statusStr = "Head opened"
            case "02":
                statusStr = "Paper Jam"
            case "03":
                statusStr = "Paper Jam and head opened"
            case "04":
                statusStr = "Out of paper"
            case "05":
                statusStr = "Out of paper and head opened"
            case "08":
                statusStr = "Out of ribbon"
            case "09":
                statusStr = "Out of ribbon and head opened"
            case "0A":
                statusStr = "Out of ribbon and paper jam"
            case "0B":
                statusStr = "Out of ribbon, paper jam and head opened"
            case "0C":
                statusStr = "Out of ribbon and out of paper"
            case "0D":
                statusStr = "Out of ribbon, out of paper and head opened"
            case "10":
                statusStr = "Pause"
            case "20":
                statusStr = "Printing"
            case "80":
                statusStr = "Other error"
            default:
                break
            }
            self.showDialog(title: "Printer Status", msg: statusStr)
        }
    }
    
    //取得SDK版本
    @IBAction func onGetVersionClick(_ sender: Any) {
        let version = gsble.getSdkVersion()
        showDialog(title: "sdk version", msg: version)
    }
    
    @IBAction func write_EPC(_ sender: Any) {
        gsble.writeUHF(dataFormat: "H", startBlockNo:2, byteSize: 12, Gen2MemoryBank: "E", datastring: "414142424343444445454646")
        gsble.AccessPWD_Action(action: "S", password: "12345678")
        gsble.EPCPWD_Action(action: "L", password: "12345678")
        showDialog(title: "write epc", msg: "414142424343444445454646")
    }
    
    //dialog function
    func showDialog(title:String,msg:String){
        let alertController = UIAlertController(title: title, message: msg, preferredStyle: .alert)
        alertController.addAction(UIAlertAction(title: "OK", style: .default))
        self.present(alertController, animated: true, completion: nil)
    }
    
}

